
/* an COCO directory entry is this many bytes long	*/

#define COCO_SECTORS		18
#define COCO_TRACKS		35	
#define COCO_SECTORS_PER_GRAN	9
#define COCO_GRANS_PER_TRACK	2
#define COCO_TOTAL_GRANS	(COCO_GRANS_PER_TRACK * (COCO_TRACKS-1))
#define COCO_NULL_GRAN		COCO_TOTAL_GRANS
#define COCO_SECTOR_SIZE	256
#define COCO_DIR_TRACK		17
#define COCO_DIR_SECTORS	9
#define COCO_DIR_SECTOR_START	2
#define COCO_ENTRY_SIZE		32
#define COCO_ENTRY_PER_SECTOR	8
#define COCO_FAT_SECTOR		1
#define COCO_FAT_TRACK		COCO_DIR_TRACK

#define COCO_TO_GRAN_ID(t,s)	((((t)<17)?(t):(t)-1)*COCO_GRANS_PER_TRACK+((s)/COCO_SECTORS_PER_GRAN))

#define COCO_GRAN_FREE(cocofs,g)     (cocofs->FAT[g]==0xff)

#define COCO_ENTRY_UNUSED(b)		((b)->name[0] == 0x00)
#define COCO_ENTRY_UNUSED_LAST(b)	((b)->name[0] == 0xff)

#define COCO_MARK_ENTRY_UNUSED(b)	((b)->name[0] = 0x00)
#define COCO_MARK_ENTRY_UNUSED_LAST(b)	((b)->name[0] = 0xff)

#define COCO_FILETYPE_BASIC	0
#define COCO_FILETYPE_DATA	1
#define COCO_FILETYPE_MACHINE	2
#define COCO_FILETYPE_TEXT	3

#define COCO_ASCII_YES		0xff
#define COCO_ASCII_NO		0

typedef int	coco_inode;

struct coco_dirent {
    unsigned char	name[8];	/* filename, padded on right	*/
    unsigned char	ext[3];		/* extention, padded on right	*/
    int			filetype;	/* 0=BASIC, 1=BASIC data, 2=machine, 3=text */
    int			ascii;		/* 0 = binary, 0xff = ascii	*/
    int			firstgran;	/* first granule of file	*/
    int			lastsecbytes;	/* bytes in the last sector	*/
    char		reserved[16];	/* the reserved data in entry	*/
};

struct coco_dir {
    struct coco_dirent	dirent[72];	/* up to 72 entries (9 sectors)	*/
};

/*
 * and "INODE" is a unique identifier for an entry in the
 * filesystem.  For this code, it is simply the directory block
 * number along with the entry within that block.  The INODE
 * is just an int with the two put together.
 */

#define COCO_INODE(i,j)		((coco_inode)((i<<8)+j))

/*
 * a "NULL" inode is one that can't be reached within a directory
 * -1 is chosen becuase this can't happen in COCO.  The following
 * was the previous definition, though this was simply overkill:
 * #define COCO_INODE_NULL(h)	((h)->blocks<<8&(h)->block[0].entries) 
 */
#define COCO_INODE_NULL		((coco_inode)-1)

#define COCO_INODE_SECTOR(i)	((int)(((i)>>8)&0xff))
#define COCO_INODE_ENTRY(i)	((int)((i)&0xff))

struct cocofs;

extern void coco_dir_init(struct coco_dir *);
extern void coco_dir_cleanup(struct coco_dir *);

extern struct coco_dirent *coco_dirent(struct cocofs *, coco_inode);
